package com.hero.ui.dialog;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.WindowConstants;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

import com.hero.objects.GenericObject;

/**
 * Copyright (c) 2000 - 2005, CompNet Design, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, is prohibited unless the following conditions are met: 1.
 * Express written consent of CompNet Design, Inc. is obtained by the developer.
 * 2. Redistributions must retain this copyright notice. THIS SOFTWARE IS
 * PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * @author CompNet Design, Inc.
 * @version $Revision$
 */

public class NotesDialog extends JDialog {

	private static final long serialVersionUID = -1682716594008160708L;

	JTextArea notesTA;

	private JScrollPane notesScroll;

	JCheckBox includeInPrintoutCheck;

	JButton closeBtn;

	GenericObject object;

	public NotesDialog(GenericObject obj, JDialog owner) {
		super(owner, "Notes for " + obj.getDisplay(), true);
		object = obj;
		setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);
		initWidgets();
		initListeners();
		layoutComponent();
		pack();
	}

	private void initListeners() {
		notesTA.getDocument().addDocumentListener(new DocumentListener() {
			public void changedUpdate(DocumentEvent e) {
				object.setNotes(notesTA.getText());
			}

			public void insertUpdate(DocumentEvent e) {
				object.setNotes(notesTA.getText());
			}

			public void removeUpdate(DocumentEvent e) {
				object.setNotes(notesTA.getText());
			}
		});
		includeInPrintoutCheck.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				object.setIncludeNotesInPrintout(includeInPrintoutCheck
						.isSelected());
			}
		});
		closeBtn.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				setVisible(false);
			}
		});
	}

	private void initWidgets() {
		notesTA = new JTextArea(object.getNotes(), 6, 20);
		notesTA.setWrapStyleWord(true);
		notesTA.setLineWrap(true);
		notesScroll = new JScrollPane(notesTA);
		notesScroll.setPreferredSize(notesTA.getPreferredSize());
		includeInPrintoutCheck = new JCheckBox("Include in print out");
		includeInPrintoutCheck.setSelected(object.isIncludeNotesInPrintout());
		closeBtn = new JButton("Close");
	}

	private void layoutComponent() {
		JPanel panel = new JPanel(new GridBagLayout());
		GridBagConstraints gbc = new GridBagConstraints();
		gbc.gridx = 0;
		gbc.gridy = 0;
		gbc.weightx = 1;
		gbc.weighty = 1;
		gbc.anchor = GridBagConstraints.CENTER;
		gbc.fill = GridBagConstraints.BOTH;
		gbc.insets = new Insets(5, 5, 5, 5);
		panel.add(notesScroll, gbc);
		gbc.gridy++;
		gbc.fill = GridBagConstraints.NONE;
		gbc.weightx = 0;
		gbc.weighty = 0;
		panel.add(includeInPrintoutCheck, gbc);
		gbc.gridy++;
		panel.add(closeBtn, gbc);
		setContentPane(panel);
	}
}